# -*- coding: utf-8 -*-
from ppms.migration import SQLPacket, PacketCategory, MaxVersionDependency, ChangeDTPPacket

from ppms.constants import DBMS_ORACLE, DBMS_MSSQL

TRIGGER_ORACLE = """CREATE OR REPLACE TRIGGER PLANTA_DELETE_REQUEST_PERIOD
    instead of delete
    on V_PLANTA_REQUEST_PERIOD
    for each row
BEGIN
    NULL;
END;
"""

TRIGGER_MSSQL = """CREATE TRIGGER PLANTA_DELETE_REQUEST_PERIOD
    ON V_PLANTA_REQUEST_PERIOD
    INSTEAD OF DELETE
AS
BEGIN
  DECLARE @dummy1 bit
END"""


class AddOnDeleteToRequestPeriodView(SQLPacket, ChangeDTPPacket):
    """Adds on delete triggers for V_PLANTA_REQUEST_PERIOD"""
    done_after_success = True
    run_on_startup = True
    category = PacketCategory.CATEGORY_MANDATORY
    wi_number = 26259

    def get_dependencies(self):
        return MaxVersionDependency(version='39.5.18'),

    def add_trigger(self):
        if self.DBMS == DBMS_ORACLE:
            self.modify_and_log(TRIGGER_ORACLE)
        elif self.DBMS == DBMS_MSSQL:
            self.modify_and_log(TRIGGER_MSSQL)

    def remove_trigger(self):
        self.drop_trigger('PLANTA_DELETE_REQUEST_PERIOD')

    def enable_deletion_flag(self):
        record = self.get_record(406, [352522], ['delete_enabled', 'read_only'])

        return self.change_value(record, 'delete_enabled', old_value=False, new_value=True) and \
               self.change_value(record, 'read_only', old_value=True, new_value=False)

    def change_relation_delete_flag(self):
        record = self.get_record(416, ['204', '466', '066449'], ['delete_flag'])

        return self.change_value(record, 'delete_flag', old_value=3, new_value=0)

    def fix(self, packet_runner):
        self.remove_trigger()
        self.add_trigger()

        # Port customizing for standalone packet execution
        if not (self.enable_deletion_flag() and self.change_relation_delete_flag()):
            self.log('Error while changing customizing, please change manually')
        else:
            self.log('Customizing adapted successfully')

        return self.success()
